/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mshg   terrain;
Marker marker[2]; // 2 markers
/******************************************************************************/
void InitPre()
{
   App.name="Markers";
   App.flag=APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.3);

   Cam.pitch=-0.5;
   Cam.dist =10;
}
Bool Init()
{
   terrain.load("obj/terrain/0.mshg"); // terrain
   Sun.set(*Gfxs("gfx/sky/sun.gfx"));  // sun
   Sky.set();                          // sky

   // setup markers
   REPA(marker)
   {
      Marker &m=marker[i];
      m.glow =false;
      m.color=(i ? YELLOW : RED);
      m.gfx  =Gfxs("gfx/particle/star.gfx");
      m.size =2;
      m.range_opaque=0.2;
      m.range_fade  =0.3;
      m.local_matrix.setPosDir(Vec(0,0,0), Vec(0,1,0)); // setup matrix to (0,0,0) position, facing up (0,1,0)

      // set matrix position at terrain surface
      PosPointMeshY(Vec2(i ? 1 : -1, 0),terrain,&m.local_matrix.pos);
   }
   return true;
}
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01,500,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   // rotate markers matrix in their Z axis according to time delta
   REPA(marker)marker[i].local_matrix.orn.rotateZVec(Tm.d);

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         terrain.draw();
      break;

      // markers can be rendered in RM_OVERLAY, RM_PRT_BLN and RM_PRT_PAL modes, in this tutorial we'll use RM_PRT_BLN
      case RM_PRT_BLN:
         REPA(marker)marker[i].draw(MatrixIdentity);
      break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
